/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
*
*  Filename: JCFMeetingAccountController.h
*
*  Generated on 
*
*  Copyright  Cisco Systems, Inc., All rights reserved.
*  170 West Tasman Drive, San Jose, California, 95134, USA
*
*  CONFIDENTIAL AND PROPRIETARY INFORMATION - DO NOT DISCLOSE
*
******************************************************************************/

#import "ObjCHelpers.h"
#import "ObjcWrapperCache.h"
#import "CSISecureString.h"
#import <Foundation/NSDate.h>
#import "ObjectFoundry.h"
#import <objc/runtime.h>

#import "JCFUnifiedBusinessObject.h"
#import "JCFMeetingAccountController.h"
#import "JCFMeetingAccountCallback.h"
#import "JCFMeetingSite.h"
#include "csfunified/services/interface/MeetingSite.h"

//cpp interface
#include "csfunified/services/interface/MeetingAccountController.h" 




#include <map>

typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountController> MeetingAccountControllerPtr;
typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountControllerObserver> MeetingAccountControllerObserverPtr;

typedef SMART_PTR_NS::weak_ptr<CSFUnified::MeetingAccountController> MeetingAccountControllerWPtr;
typedef std::owner_less<MeetingAccountControllerWPtr> wp_less;
typedef std::map<MeetingAccountControllerWPtr, JCFMeetingAccountController*, wp_less> MeetingAccountControllerCache;
static MeetingAccountControllerCache sCache;

@interface JCFMeetingAccountController ()

@property (nonatomic, readwrite, assign) struct MeetingAccountControllerOpaque *cpp;

-(id)initWithMeetingAccountControllerPtr:(MeetingAccountControllerPtr)meetingAccountController;

@end

#include "JCFMeetingAccountControllerObserver.h"

struct MeetingAccountControllerOpaque
{
	
	MeetingAccountControllerOpaque(JCFMeetingAccountController* ObjcOwner, MeetingAccountControllerPtr meetingAccountController) 
	:mMeetingAccountController(meetingAccountController),
	mMeetingAccountControllerObserver(new JCFMeetingAccountControllerObserver(ObjcOwner))
	{
		mMeetingAccountController->addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingAccountControllerObserver>(mMeetingAccountControllerObserver));
	};
	
	~MeetingAccountControllerOpaque() 
	{
		mMeetingAccountController->removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingAccountControllerObserver>(mMeetingAccountControllerObserver));
	};
	
	MeetingAccountControllerPtr mMeetingAccountController;
	
private:
	MeetingAccountControllerObserverPtr mMeetingAccountControllerObserver;
};

@implementation JCFMeetingAccountController

@synthesize cpp = mMeetingAccountControllerCpp;

#pragma mark Base Unified Business Object Properties




#pragma mark Constructors

-(JCFMeetingAccountController*) initWithMeetingAccountControllerPtr:(MeetingAccountControllerPtr)meetingAccountController
{
	@synchronized([self class])
	{
		MeetingAccountControllerWPtr wp(meetingAccountController);
		MeetingAccountControllerCache::const_iterator iter = sCache.find(wp);
		if (iter != sCache.end())
		{
			[self release];
			self = [(*iter).second retain];
		}
		else
		{
			self = [super initSuperWithUnifiedBusinessObjectPtr : meetingAccountController];
			if (self != nil)
			{
				if ([self class] == [JCFMeetingAccountController class])
				{
					if (meetingAccountController != NULL)
					{
						self.cpp = new MeetingAccountControllerOpaque(self, meetingAccountController);
						sCache[wp] = self;
					}
					else
					{
						[self release];
						self = nil;
					}
				}
			}
		}
	}

	return self;
}

-(JCFMeetingAccountController*) initSuperWithMeetingAccountControllerPtr:(MeetingAccountControllerPtr)meetingAccountController
{
	self = [super initSuperWithUnifiedBusinessObjectPtr : meetingAccountController];

	if (self != nil)
	{
		if ([self class] == [JCFMeetingAccountController class])
		{
			if (meetingAccountController == NULL)
			{
				[self release];
				self = nil;
			}
		}
	}
	return self;
}

-(id) initWithPtr:(UnifiedBusinessObjectPtr) cppPtr
{
	MeetingAccountControllerPtr meetingAccountController = SMART_PTR_NS::dynamic_pointer_cast<CSFUnified::MeetingAccountController>(cppPtr);
	self = [self initWithMeetingAccountControllerPtr: meetingAccountController ];
	return self;
}

-(JCFMeetingAccountController*) init
{
    NSAssert(NO, @"init with initWithMeetingAccountControllerPtr:");
    [self release];
    self = nil;
	return nil;
}

+ (BOOL)automaticallyNotifiesObserversForKey:(NSString *)theKey {
	
	return [super automaticallyNotifiesObserversForKey:theKey];
}

+ (BOOL)accessInstanceVariablesDirectly
{
	return NO;
}

- (void)willChangeValueForKey:(NSString *)key
{
	kvoUpdate = YES;

	[super willChangeValueForKey:key];
}

- (void)didChangeValueForKey:(NSString *)key
{
	kvoUpdate = NO;
	[super didChangeValueForKey:key];
}

- (void)addObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
	

	[super addObserver:observer forKeyPath:keyPath options:options context:context];
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath context:(void *)context
{
	[super removeObserver:observer forKeyPath:keyPath context:context];

	
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath
{
	[super removeObserver:observer forKeyPath:keyPath];

	
}

-(void)dealloc
{
	@synchronized([self class])
	{
		if (self.cpp != NULL)
		{
			MeetingAccountControllerWPtr wp(self.cpp->mMeetingAccountController);
			sCache.erase(wp);

	  		delete self.cpp;
  			self.cpp = NULL;
	  	}
	}

  	[super dealloc];
}

-(MeetingAccountControllerPtr) getMeetingAccountControllerPtr
{
	return self.cpp->mMeetingAccountController;
}


-(void) registerMeetingAccountCallback:(id<JCFMeetingAccountCallbackDelegate>)meetingAccountCallback 
{
JCFMeetingAccountCallback *cbmeetingAccountCallback;

	JCFMeetingAccountCallback *testmeetingAccountCallback = [[[JCFMeetingAccountCallback alloc] init] autorelease];
	testmeetingAccountCallback.delegate = meetingAccountCallback;
	if([ObjcWrapperCache isCallbackCached:testmeetingAccountCallback])
	{
		cbmeetingAccountCallback = (JCFMeetingAccountCallback*)[ObjcWrapperCache getCachedCallback:testmeetingAccountCallback];
		[cbmeetingAccountCallback retain];
	}
	else
	{
		cbmeetingAccountCallback = [[JCFMeetingAccountCallback alloc] init];
		cbmeetingAccountCallback.delegate = meetingAccountCallback;
		[ObjcWrapperCache cacheCallback:cbmeetingAccountCallback];
	}
	testmeetingAccountCallback.delegate = nil;
	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountCallback> meetingAccountCallbackCpp;

	
	meetingAccountCallbackCpp = cbmeetingAccountCallback.getCppCallback;
	self.cpp->mMeetingAccountController->registerMeetingAccountCallback(meetingAccountCallbackCpp);
	[cbmeetingAccountCallback release];
}

-(void) unregisterMeetingAccountCallback:(id<JCFMeetingAccountCallbackDelegate>)meetingAccountCallback 
{
JCFMeetingAccountCallback *cbmeetingAccountCallback;

	JCFMeetingAccountCallback *testmeetingAccountCallback = [[[JCFMeetingAccountCallback alloc] init] autorelease];
	testmeetingAccountCallback.delegate = meetingAccountCallback;
	if([ObjcWrapperCache isCallbackCached:testmeetingAccountCallback])
	{
		cbmeetingAccountCallback = (JCFMeetingAccountCallback*)[ObjcWrapperCache getCachedCallback:testmeetingAccountCallback];
		[cbmeetingAccountCallback retain];
	}
	else
	{
		cbmeetingAccountCallback = [[JCFMeetingAccountCallback alloc] init];
		cbmeetingAccountCallback.delegate = meetingAccountCallback;
		[ObjcWrapperCache cacheCallback:cbmeetingAccountCallback];
	}
	testmeetingAccountCallback.delegate = nil;
	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountCallback> meetingAccountCallbackCpp;

	
	meetingAccountCallbackCpp = cbmeetingAccountCallback.getCppCallback;
	self.cpp->mMeetingAccountController->unregisterMeetingAccountCallback(meetingAccountCallbackCpp);
	[cbmeetingAccountCallback release];
}

-(BOOL) isReady
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingAccountController->isReady();
	return resultCpp;
}

-(BOOL) isActive
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingAccountController->isActive();
	return resultCpp;
}

-(int) getMeetingSiteCount
{


	int resultCpp;
	
	resultCpp = self.cpp->mMeetingAccountController->getMeetingSiteCount();
	return resultCpp;
}

-(JCFMeetingSite*) getMeetingSiteByIndex:(int)index 
{

	int indexCpp;

	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> resultCpp;
	
	indexCpp = index;
	resultCpp = self.cpp->mMeetingAccountController->getMeetingSiteByIndex(indexCpp);
	JCFMeetingSite* resultObjc = [[[JCFMeetingSite alloc] initWithMeetingSitePtr:resultCpp] autorelease];
	return resultObjc;
}

-(JCFMeetingSite*) getDefaultMeetingSite
{


	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> resultCpp;
	
	resultCpp = self.cpp->mMeetingAccountController->getDefaultMeetingSite();
	JCFMeetingSite* resultObjc = [[[JCFMeetingSite alloc] initWithMeetingSitePtr:resultCpp] autorelease];
	return resultObjc;
}

-(void) checkSSOSite:(NSString*)siteUrl 
{

	std::string siteUrlCpp;

	
	siteUrlCpp = JCFStdStringForNSString(siteUrl);
	self.cpp->mMeetingAccountController->checkSSOSite(siteUrlCpp);
}

-(int) isSSOSite:(NSString*)siteUrl 
{

	std::string siteUrlCpp;

	int resultCpp;
	
	siteUrlCpp = JCFStdStringForNSString(siteUrl);
	resultCpp = self.cpp->mMeetingAccountController->isSSOSite(siteUrlCpp);
	return resultCpp;
}

-(void) setActiveSiteSiteurl:(NSString*)siteUrl userName:(NSString*)userName userPass:(CSISecureString*)userPass 
{

	std::string siteUrlCpp;
	std::string userNameCpp;
	csf::SecureString userPassCpp;

	
	siteUrlCpp = JCFStdStringForNSString(siteUrl);
	userNameCpp = JCFStdStringForNSString(userName);
	userPassCpp = JCFSecureStringForCSISecureString(userPass);
	self.cpp->mMeetingAccountController->setActiveSite(siteUrlCpp, userNameCpp, userPassCpp);
}

-(void) setActiveSiteSiteurl:(NSString*)siteUrl userName:(NSString*)userName sessionTicket:(NSString*)sessionTicket keepAliveTime:(long)keepAliveTime 
{

	std::string siteUrlCpp;
	std::string userNameCpp;
	std::string sessionTicketCpp;
	long keepAliveTimeCpp;

	
	siteUrlCpp = JCFStdStringForNSString(siteUrl);
	userNameCpp = JCFStdStringForNSString(userName);
	sessionTicketCpp = JCFStdStringForNSString(sessionTicket);
	keepAliveTimeCpp = keepAliveTime;
	self.cpp->mMeetingAccountController->setActiveSite(siteUrlCpp, userNameCpp, sessionTicketCpp, keepAliveTimeCpp);
}

-(void) removeSite:(NSString*)siteUrl 
{

	std::string siteUrlCpp;

	
	siteUrlCpp = JCFStdStringForNSString(siteUrl);
	self.cpp->mMeetingAccountController->removeSite(siteUrlCpp);
}

-(int) getSiteLastError
{


	int resultCpp;
	
	resultCpp = self.cpp->mMeetingAccountController->getSiteLastError();
	return resultCpp;
}

-(NSString*) getSiteLastErrorMessage
{


	std::string resultCpp;
	
	resultCpp = self.cpp->mMeetingAccountController->getSiteLastErrorMessage();
	NSString *resultObjc = JCFNSStringForStdString(resultCpp);
	return resultObjc;
}



@end